<?php
include("asl.php");

try {
    $conn = new PDO("mysql:host=$servername;dbname=$mydb", $username, $password, array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"));
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    echo "Connection failed: " . $e->getMessage();
}

// بررسی اعتبار یوزر و پسورد (مثل بقیه فایل‌ها)
$user = $_POST['user'];
$pass = $_POST['pass'];
$getpass = hash_hmac('md5', $pass, 'salt');

$sql = "SELECT * FROM admin WHERE user = :user AND pass = :pass";
$stmt = $conn->prepare($sql);
$stmt->execute(['user' => $user, 'pass' => $getpass]);
$admin = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$admin) {
    echo "<p style='color:red'>یوزرنیم و یا پسورد اشتباه وارد شده</p><br />
          <a href='enter.php' target='_blank'>بازگشت به صفحه ورود</a>";
    exit();
}

// کوئری برای آگهی‌های فروش (sells) توسط همکار
$sql = "SELECT s.* FROM sells s JOIN colleagues c ON s.chatid = c.chatid WHERE s.status = 'accepted' AND s.is_colleague = 1";
$stmt = $conn->prepare($sql);
$stmt->execute();
$sells = $stmt->fetchAll(PDO::FETCH_ASSOC);

// کوئری برای آگهی‌های اجاره (rents) توسط همکار
$sql = "SELECT r.* FROM rents r JOIN colleagues c ON r.chatid = c.chatid WHERE r.status = 'accepted' AND r.is_colleague = 1";
$stmt = $conn->prepare($sql);
$stmt->execute();
$rents = $stmt->fetchAll(PDO::FETCH_ASSOC);

// نمایش آگهی‌ها با استایل مشابه بقیه بخش‌ها
?>
<!DOCTYPE HTML>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>آگهی‌های همکاران</title>
    <link rel="Stylesheet" type="text/css" href="style.css" />
    <style>
        @font-face {
            font-family: 'amir';
            src: url('font/BKoodakBold.ttf')format('truetype'),
                 url('font/BKoodakBold.eot')format('eot'),
                 url('font/BKoodakBold.woff')format('woff');
        }
    </style>
</head>
<body dir="rtl" align="center">
    <div align="center">
        <h1 class="white">پنل ربات</h1>
        <h4 class="white">آگهی‌های همکاران</h4>
        <div id="content" align="right">
            <div id="content-content">
                <table>
                    <tr>
                        <th class="th">کد ملک</th>
                        <th class="th">نوع ملک</th>
                        <th class="th">متراژ</th>
                        <th class="th">وضعیت</th>
                    </tr>
                    <?php
                    foreach ($sells as $sell) {
                        echo "<tr>";
                        echo "<td class='td'>" . $sell['id'] . "</td>";
                        echo "<td class='td'>" . $sell['type'] . "</td>";
                        echo "<td class='td'>" . $sell['meterage'] . "</td>";
                        echo "<td class='td'>" . $sell['status'] . "</td>";
                        echo "</tr>";
                    }
                    foreach ($rents as $rent) {
                        echo "<tr>";
                        echo "<td class='td'>" . $rent['id'] . "</td>";
                        echo "<td class='td'>" . $rent['type'] . "</td>";
                        echo "<td class='td'>" . $rent['meterage'] . "</td>";
                        echo "<td class='td'>" . $rent['status'] . "</td>";
                        echo "</tr>";
                    }
                    if (empty($sells) && empty($rents)) {
                        echo "<tr><td colspan='4' class='td'>هیچ آگهی‌ای توسط همکاران ثبت نشده است.</td></tr>";
                    }
                    ?>
                </table>
            </div>
        </div>
    </div>
    <?php
    $conn = null;
    ?>
</body>
</html>